#include "crosshairwidget.h"

#include <QTimer>
#include <QPainter>
#include <QPaintEvent>

CrosshairWidget::CrosshairWidget(QWidget *parent)
    : QWidget(parent)
{
    setWindowTitle(tr("Céllövölde"));

    timer = new QTimer(this); // időzítő erre az ablakra
    connect(timer, SIGNAL(timeout()), this, SLOT(update()));
    // az időzítő meghívja az update-t, ami a paintEvent-t
    timer->start(10); // azonnal elindítjuk 0,1 másodperces késleltetéssel

    setCursor(Qt::CrossCursor); // kurzor beállítása célkeresztre
}

CrosshairWidget::~CrosshairWidget()
{
    delete timer;
}

void CrosshairWidget::paintEvent(QPaintEvent *)
{
    QPainter painter(this); // rajzoló objektum
    painter.setRenderHint(QPainter::Antialiasing); // élsimítás használata

    QPoint mouseLocation = QCursor::pos(); // egérpozíció lekérdezése a képernyőn
    mouseLocation = QWidget::mapFromGlobal(mouseLocation); // egérpozció transzformálása az ablakra

    QPen dashDotRedPen(QBrush(QColor(255, 0, 0)), 2, Qt::DashDotLine); // pontozott-szaggatott vonalú piros toll
    QPen solidRedPen(QBrush(QColor(255, 0, 0)), 3); // sima piros toll
    QBrush greenBrush(QColor(100, 100, 100), Qt::Dense1Pattern); // pöttyös szürke ecset

    painter.fillRect(0, 0, width(), height(), greenBrush); // háttér kitöltése

    painter.setPen(QPen(Qt::yellow, 4)); // fekete, 4 vastag toll beállítása
    foreach(QPoint point, hitPoints) // kirajzoljuk a pontokat
    {
        painter.drawLine(point.x() - 10, point.y() - 10, point.x() + 10, point.y() + 10);
        painter.drawLine(point.x() - 10, point.y() + 10, point.x() + 10, point.y() - 10);
    }
    painter.setPen(dashDotRedPen); // toll beállítása
    painter.setBrush(Qt::NoBrush); // ecset eltávolítása
    painter.drawLine(0, mouseLocation.y(), width(), mouseLocation.y()); // vonalak kirajzolása
    painter.drawLine(mouseLocation.x(), 0, mouseLocation.x(), height());

    painter.setPen(solidRedPen); // toll beállítása
    painter.drawEllipse(mouseLocation.x() - 30, mouseLocation.y() - 30, 60, 60); // kör kirajzolása
}

void CrosshairWidget::keyPressEvent(QKeyEvent *event)  // billentyű lenyomása
{
    if (event->key() == Qt::Key_Space)
    {
        hitPoints.append(QWidget::mapFromGlobal(QCursor::pos())); // új pont felvétele
    }
}

void CrosshairWidget::mousePressEvent(QMouseEvent*)  // egér lenyomása
{
    hitPoints.append(QWidget::mapFromGlobal(QCursor::pos())); // új pont felvétele
}

