package media.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import media.Media;
import media.data.Book;
import media.data.EBook;
import media.data.Newspaper;
import media.data.Rating;

public class MainTest {
	public static void main(final String[] args) {
		int result = 2; // Ha mar fordul a kod a megfelelo csomagszerkezettel
		
		// Ezekbol 2 valaszthato, maximum 4-es erdemjegy szerezheto veluk
		result += testEqualsBugFixed();
		result += testMedianFunction();
		result += testFixingTitles();
		
		result = Math.min( 4, result );
		
		// 5-os erdemjegyert
		result += testIfEBookSubclassed();
		result += testIfCloningSupported();
		
		if ( result > 2 ) {
			System.out.println();
		}
		
		System.out.println( "---------" );
		System.out.println( "Result: " + Math.min( 5, result ) );
		System.out.println( "---------" );
	}
	
	/**
	 * A szolgaltatott {@link Rating#equals(Object)} fuggveny valamiert proglemas. Javitsd ki!
	 */
	private static int testEqualsBugFixed() {
		final Rating a = new Rating( "thecalling", new Book( "The Calling", 10 * 1000, "David Gaider" ), 4 );
		
		String tricky = "the";
		tricky = tricky + "calling" + "";
		final Rating b = new Rating( tricky, new Book( "The Calling", 10 * 1000, "David Gaider" ), 4 );
		
		if ( ! a.equals( b ) ) {
			return 0;
		}
		
		System.out.println( "[OK] The equals() implementation fixed." );
		return 1;
	}
	
	/**
	 * Implementalando a {@link Media#getMedianScoreOfRatings()} fuggveny.
	 */
	private static int testMedianFunction() {
		final Media media = new Media();
		
		media.addRating( new Rating( "A", new Book( "Title 1", 10, "Author 1" ), 3 ) );
		media.addRating( new Rating( "B", new Book( "Title 2", 20, "Author 2" ), 1 ) );
		media.addRating( new Rating( "C", new Book( "Title 3", 30, "Author 3" ), 2 ) );
		
		if ( media.getMedianScoreOfRatings() != 2 ) {
			return 0;
		}
		
		media.addRating( new Rating( "C", new Book( "Title 3", 30, "Author 3" ), 4 ) );
		media.addRating( new Rating( "D", new Book( "Title 4", 40, "Author 4" ), 4 ) );
		
		if ( media.getMedianScoreOfRatings() != 3 ) {
			return 0;
		}
		
		System.out.println( "[OK] Median implemented." );
		return 1;
	}
	
	/**
	 * Implementalando a {@link Media#fixTitles()} fuggveny.
	 */
	private static int testFixingTitles() {
		final Media media = new Media();
		media.addRating( new Rating( "1", new Newspaper( "usa today", 2528437, "Kenneth Paulson" ), 5 ) );
		media.addRating( new Rating( "2", new Newspaper( "Wall Street Journal", 2058342, "Paul A. Gigot" ), 4 ) );
		media.addRating( new Rating( "3", new Newspaper( "times", 1683855, "James Harding" ), 3 ) );
		
		media.fixTitles(); // Ezt kell implementalni
		
		final Set<String> set = new HashSet<String>();
		
		for (final Rating act : media.getRatings()) {
			set.add( act.getMedium().getTitle() );
		}
		
		final Set<String> expected = new HashSet<String>( Arrays.asList( "Usa today", "Wall street journal", "Times" ) );
		
		if ( ! set.equals( expected ) ) {
			return 0;
		}
		
		System.out.println( "[OK] Method fixTitles() implemented." );
		return 1;
	}
	
	/**
	 * Adott az {@link EBook} osztaly, amely tipikus copy & paste koddal szuletett. Illeszd be az osztalyt a kialakitott
	 * hierarchiaba, tedd a {@link Book} osztaly alosztalyava!
	 */
	private static int testIfEBookSubclassed() {
		final Collection<EBook> defaultEBooks = EBook.getDefaultEBookCollection();
		if ( 0 == defaultEBooks.size() ) {
			return 0;
		}
		
		for (final EBook act : defaultEBooks) {
			final Object dummy = act;
			if ( dummy instanceof Book ) {
				final Book book = (Book) dummy;
				
				// @formatter:off
				if ( ! book.getAuthor().equals( act.getAuthor() ) ||
						book.getCopies() != act.getCopies() ||
					  ! book.getTitle().equals( book.getTitle() ) ) {
					return 0;
				}
				// @formatter:on
				
			} else {
				return 0;
			}
		}
		
		System.out.println( "[OK] EBook abstracted." );
		return 1;
	}
	
	/**
	 * Eloadason targyaltatok a klonozassal kapcsolatos kerdeseket. Valosits meg egy egyszeru <code>clone()</code> fuggvenyt
	 * az {@link media.data.AMedium} osztalyban!
	 */
	private static int testIfCloningSupported() {
		try {
			final Book book = new Book( "Book title", 10, "Book author" );
			final Book clonedBook = (Book) book.clone();
			
			if ( null == clonedBook ) {
				return 0;
			}
			
			final Newspaper newspaper = new Newspaper( "Newspaper title", 20, "Editor" );
			final Newspaper clonedNewspaper = (Newspaper) newspaper.clone();
			
			clonedNewspaper.setTitle( "Some other Title" );
			
			// @formatter:off
			if ( ! book.getTitle().equals( clonedBook.getTitle() ) ||
					book.getCopies() != clonedBook.getCopies() ||
					! book.getAuthor().equals( clonedBook.getAuthor() ) ) {
				return 0;
			}
			
			if ( newspaper.getTitle().equals( clonedNewspaper.getTitle() ) ||
				      newspaper.getCopies() != clonedNewspaper.getCopies() ||
					! newspaper.getEditor().equals( clonedNewspaper.getEditor() ) ) {
				return 0;
			}
			// @formatter:on
			
			System.out.println( "[OK] Clone implemented." );
			return 1;
		} catch (final CloneNotSupportedException e) {
			return 0;
		}
	}
	
}
