package media;

// Hianyzo importok

public class Media {
	private final ArrayList<Rating> ratings = new ArrayList<Rating>();
	
	public int getRatingsNumber() {
		return ratings.size();
	}
	
	public Collection<Rating> getRatings() {
		return Collections.unmodifiableCollection( ratings );
	}
	
	public void addRating(final Rating rating) {
		ratings.add( rating );
	}
	
	public void modifyRating(final String id, final int score) {
		final int idx = ratings.indexOf( Rating.createDummy( id ) );
		ratings.get( idx ).setScore( score );
	}
	
	public void deleteRating(final String id) {
		final int idx = ratings.indexOf( Rating.createDummy( id ) );
		ratings.remove( idx );
	}
	
	public Rating getWorstRating() {
		return Collections.min( ratings );
	}
	
	public Rating getBestRating() {
		return Collections.max( ratings );
	}
	
	// ======================================================================================================================
	// === New Stuff Here ===================================================================================================
	
	/**
	 * A rendezett <code>score</code> ertekekbol visszaadja azt, amelyik kozepen van (paratlan elemszam eseten lefele
	 * kerekitjuk a felezett erteket).
	 */
	public int getMedianScoreOfRatings() {
		// TODO Implementacio
		return 0;
	}
	
	/**
	 * Vegig kell menni a tarolt ertekeleseken, es nagybetusiteni kell a cimeket a kovetkezokeppen: az elso karaktert
	 * nagybetusre csereljuk, az osszes tobbit kicsire.
	 */
	public void fixTitles() {
		// TODO Implementacio
	}
	
}
