package media.data;

public class Rating
		implements Comparable<Rating> {
	private final String id;
	private final AMedium medium;
	
	private int score;
	
	public Rating(final String id, final AMedium medium, final int score) {
		super();
		
		this.id = id;
		this.medium = medium;
		
		setScore( score );
	}
	
	protected Rating(final String id) {
		super();
		
		this.id = id;
		this.medium = null;
		this.score = - 1;
	}
	
	public static Rating createDummy(final String id) {
		return new Rating( id );
	}
	
	public String getId() {
		return id;
	}
	
	public AMedium getMedium() {
		return medium;
	}
	
	public int getScore() {
		return score;
	}
	
	public void setScore(final int score) {
		if ( score < 1 || 5 < score ) {
			throw new IllegalArgumentException( "1 <= score <= 5 expected, but value = " + score );
		}
		
		this.score = score;
	}
	
	public int compareTo(final Rating o) {
		return score - o.score;
	}
	
	@Override
	public int hashCode() {
		return ( id != null ) ? id.hashCode() : 11;
	}
	
	// CHECKME Valami nem stimmel ezzel...
	@Override
	public boolean equals(final Object obj) {
		if ( obj instanceof Rating ) {
			final Rating other = (Rating) obj;
			return id == other.id;
		}
		
		return false;
	}
	
	@Override
	public String toString() {
		return "Rating [id=" + id + ", media=" + medium + ", score=" + score + "]";
	}
}
