package media;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import media.data.Rating;

public class Media {
	private final ArrayList<Rating> ratings = new ArrayList<Rating>();
	
	public int getRatingsNumber() {
		return ratings.size();
	}
	
	public Collection<Rating> getRatings() {
		return Collections.unmodifiableCollection( ratings );
	}
	
	public void addRating(final Rating rating) {
		ratings.add( rating );
	}
	
	public void modifyRating(final String id, final int score) {
		final int idx = ratings.indexOf( Rating.createDummy( id ) );
		ratings.get( idx ).setScore( score );
	}
	
	public void deleteRating(final String id) {
		final int idx = ratings.indexOf( Rating.createDummy( id ) );
		ratings.remove( idx );
	}
	
	public Rating getWorstRating() {
		return Collections.min( ratings );
	}
	
	public Rating getBestRating() {
		return Collections.max( ratings );
	}
	
	// ======================================================================================================================
	// === New Stuff Here ===================================================================================================
	
	/**
	 * A rendezett <code>score</code> ertekekbol visszaadja az atlagot (a szokasos modon kerekitve).
	 */
	public int getAverageScoreOfRatings() {
		// TODO Implementacio
		return 0;
	}
	
	/**
	 * Vegig kell menni a tarolt ertekeleseken, es minden nem alfanumerikus karaktert lecserelni egy <code>'_'</code>
	 * karakterre.
	 */
	public void fixTitles() {
		// TODO Implementacio
	}
	
}
