﻿//Készítette:    Gregorics Tibor
//Dátum:         2017.08.31.
//Feladat:       Szekvenciális inputfájl felsorolóinak ososztálya

#pragma once

#include <typeinfo>
#include <sstream>

#include "enumerator.hpp"

//Szöveges állomány szekvenciális inputfájlkénti felsorolását definiáló osztály-sablon
//Műveletek: first(), next(), end(), current()
//Reprezentáció:_f - a felsorolni kívánt szöveges állomány
//              _df  - az éppen felsorolt Item típusú elem
template <typename Item>  // Item implementálja az operator>>-t
class StringStreamEnumerator : public Enumerator<Item>
{
    protected:
        std::stringstream _ss;
        Item          _df;

    public:
        enum Exceptions { OPEN_ERROR };
        StringStreamEnumerator(std::stringstream& ss) {
            _ss<<ss.rdbuf();
            if(typeid(Item)==typeid(char)) _ss.unsetf(std::ios::skipws);
        }

        void first()         final override { next();}
        void next()          final override { _ss >> _df; }
        bool end()     const final override { return !_ss;}
        Item current() const final override { return _df; }
};

