// Keszitette:  Bencze Gabor Peter
// Email:       gaborbencze@caesar.elte.hu
// Datum:       2018.03.16
// Feladat:     12.	Feladat
//              Egy étteremben a pincérek által felvett rendeléseket egy szekvenciális input fájlban tartják nyilván
//              az ételek neve, azon belül a rendelések időpontja szerint rendezett formában.
//              A tárolt adatok: a rendelt étel neve, a rendelés időpontja, rendelt adagok száma, egy adag ára. 
//              Melyik étel hozta az étteremnek a legtöbb bevételt (összesített darab*egységár)?

#include "foodEnor.h"
#include <iostream>
#include <sstream>

// Bemenet formatuma:
// etel_nev ido_ora ido_perc db egysegar
// (feltesszuk, hogy az etelek neveben nincs szokoz)
std::istream& operator>>(std::istream& is, Order &x) {
    is >> x.foodName >> x.hour >> x.minute >> x.orderCount >> x.unitPrice;
    return is;
}

FoodEnor::FoodEnor(const std::string &path) {
    _f.open(path.c_str());
    if(_f.fail()) {
        throw FILE_ERROR;
    }
}

// A felsorolo first muvelete
// Eloreolvasunk egy sort a bemeneti fajlbol, majd a next muveletet meghivjuk
void FoodEnor::first() {
    read();
    next();
}

// A felsorolo next muvelete
// Addig olvasunk az inputfajlbol, amig a beolvasott rendelesben a rendelt etel neve
//   megegyezik az aktualisan feldolgozott etel nevevel es amig nem ertunk a bemenet vegere
// Egy rendeles beolvasasakor a darabszam * egysegarat hozzaadjuk az adott etel altal generalt bevetelhez
// Ha _sx == abnorm, a bemeneti fajl vegere ertunk (a next elozo hivasakor), a _end-et igazara allitjuk
void FoodEnor::next() { 
    _end = _sx == abnorm;

    if(_sx == norm) {
        _current.foodName = _dx.foodName;
        _current.income = _dx.orderCount * _dx.unitPrice;
        read();
        while(_sx == norm && _current.foodName == _dx.foodName) {
            _current.income += _dx.orderCount * _dx.unitPrice;
            read();
        }
    }
}

// Kovetkezo rendeles beolvasasa _dx-be
// Ha nem sikerult beolvasni a kovetkezo rendelest,
//   _sx-et abnorm-ra allitjuk
void FoodEnor::read() {
    if(_f >> _dx) _sx = norm;
    else _sx = abnorm;
}
