// Keszitette:  Bencze Gabor Peter
// Email:       gaborbencze@caesar.elte.hu
// Datum:       2018.03.16
// Feladat:     12.	Feladat
//              Egy étteremben a pincérek által felvett rendeléseket egy szekvenciális input fájlban tartják nyilván
//              az ételek neve, azon belül a rendelések időpontja szerint rendezett formában.
//              A tárolt adatok: a rendelt étel neve, a rendelés időpontja, rendelt adagok száma, egy adag ára. 
//              Melyik étel hozta az étteremnek a legtöbb bevételt (összesített darab*egységár)?

#ifndef FOODENOR_H
#define FOODENOR_H

#include <string>
#include <fstream>
#include <iosfwd>

// Bemeneti fajl egy rekordja
// Tartalmazzas a rendelt etel nevet, a rendeles idopontjat, a darabszamot es egysegarat
struct Order {
    std::string foodName;
    int hour;
    int minute;
    int orderCount;
    int unitPrice;
    friend std::istream& operator>>(std::istream& is, Order &x);
};

// A felsorot elemek tipusa
// Tartalmazza az etel nevet es a bevetelt
struct FoodIncome {
    std::string foodName;
    int income;
};

// Egyes etelek altal generalt bevetelek felsoroloja
class FoodEnor {
public:
    enum Status {norm, abnorm};
    enum Exceptions {FILE_ERROR};
    FoodEnor(const std::string &path);
    void first();
    void next();
    FoodIncome current() const { return _current; }
    bool end() const { return _end; }
private:
    std::ifstream _f;
    Status _sx;
    FoodIncome _current;
    Order _dx;
    bool _end;
    void read();
};

#endif