// Keszitette:  Bencze Gabor Peter
// Email:       gaborbencze@caesar.elte.hu
// Datum:       2018.03.16
// Feladat:     Van-e egy szekvenciális fájlban egymást követően két azonos szám?

#include "equalsEnor.h"

// A felsorolo konstruktoraban megnyitjuk a bemeneti fajlt,
//   ha nem sikerul, kivetelt dobunk
EqualsEnor::EqualsEnor(const std::string &path) {
    _f.open(path.c_str());
    if(_f.fail()){
        throw FILE_ERROR;
    }
}

// A felsorolo first muveleteben elore olvasunk
//   ha ez sikeres volt, meghivjuk a felsorolo next muveletet
//   ha sikertelen, a felsorolo statuszat abnorm-ra allitjuk
void EqualsEnor::first() {
    if(_f >> _current) {
        next();
    }
    else _sx = abnorm;
}

// A next muveletben az elozo elem helyere masoljuk az aktualis elemet
//   majd megprobaljuk a kovetkezo elemet beolvasni
// Ha ez sikeretelen, a felsorolo allapotat abnorm-ra allitjuk
void EqualsEnor::next() {
    _prev = _current;

    if(_f >> _current) _sx = norm;
    else _sx = abnorm;
}

// A felsorolo altal felsorolt elemek logikai ertekek,
//   amelyek megadjak, hogy ket egymast koveto elem megegyezik-e
bool EqualsEnor::current() const {
    return _prev == _current;
}