// Keszitette:  Bencze Gabor Peter
// Email:       gaborbencze@caesar.elte.hu
// Datum:       2018.03.16
// Feladat:     Van-e egy szekvenciális fájlban egymást követően két azonos szám?

#include "pairEnor.h"

// A felsorolo konstruktoraban megnyitjuk a bemeneti fajlt,
//   ha nem sikerul, kivetelt dobunk
PairEnor::PairEnor(const std::string &path) {
    _f.open(path.c_str());
    if(_f.fail()){
        throw FILE_ERROR;
    }
}


// A felsorolo first muveleteben elore beolvasunk egy elemet, 
//   ha ez sikeres volt, a next muvelettel leptetjuk a felsorolot
//   ha sikertelen volt, a felsorolo allapotat abnorm-ra allitjuk
void PairEnor::first() {
    if(_f >> _dx.second) {
        next();
    }
    else _sx = abnorm;
}

// A next muveletben az elozo elem helyere masoljuk az aktulis elemet, majd
//   megprobaljuk beolvasni a kovetkezo szamot.
// Ha ez nem volt sikeres, a felsorolas allapotat abnorm-ra allitjuk
void PairEnor::next() {
    _dx.first = _dx.second;

    if(_f >> _dx.second) _sx = norm;
    else _sx = abnorm;
}